LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY shifter IS
  PORT( clk, left : IN std_logic;
        right : OUT std_logic);
END shifter;

ARCHITECTURE structural OF shifter IS
  COMPONENT dff
    PORT( d, clk : IN std_logic;
          q : OUT std_logic);
  END COMPONENT;

  SIGNAL i1, i2, i3: std_logic;

BEGIN

  u1: dff PORT MAP(d => left, clk => clk, q => i1);

  u2: dff PORT MAP(d => i1, clk => clk, q => i2);

  u3: dff PORT MAP(d => i2, clk => clk, q => i3);

  u4: dff PORT MAP(d => i3, clk => clk, q => right);

  checktime: PROCESS(clk)
    VARIABLE last_time : time := time'left;
  BEGIN
    ASSERT (NOW - last_time = 20 ns)
      REPORT "spike on clock"
      SEVERITY WARNING;
    last_time := now;
  END PROCESS checktime;
END structural;



